'use strict';

angular.module('genisis').controller('createRequestCtrl', ['$scope', 'source',
  'studyApproval', 'type', '$rootScope', '$location', 'request', 'user',
  'api', '$window',
  function ($scope, $sources, $studies, $types, $rootScope, $location,
    $requests, $user, $api, $window) {

    // Check if user can create request or access this page
    if (!$user.allowedToAccess('createRequest')) {
      // redirect back to requests page
      $location.path('/requests');
    }

    //get the request id
    $scope.request = {
      associatedRequests: [],
      notify: false,
      source: null,
      type: null,
      studyApproval: null,
      description: null,
      createdBy: $user.id()
    };

    $scope.sources = $sources;
    $scope.studyApprovals = $studies;
    $scope.types = $types;
    $scope.studies = [];
    $scope.allRequests = {};
    $scope.associatedRequests = [];
    $scope.selectedRequest = null;

    //load the available study approvals
    $studies.load().then(function (loadedApprovals) {
      loadedApprovals.unshift({
        title: 'None',
        id: null
      });
      $scope.studies = loadedApprovals;
    });

    //load the requests attached to the selected study approval
    $requests.load().then(function (loadedRequests) {
      $scope.allRequests = loadedRequests;
    });

    /**
     * Add an association
     * @param Object request object
     * @return boolean
     **/
    $scope.addAssociation = function (request) {
      if ($scope.associatedRequests.indexOf(request) === -1) {
        $scope.associatedRequests.push(request);
        return true;
      }

      return false;
    };

    /**
     * Remove an association
     * @param Object request object
     * @return boolean
     **/
    $scope.removeAssociation = function (request) {
      for (var i = 0; i < $scope.associatedRequests.length; i++) {
        if ($scope.associatedRequests[i].id === request.id) {
          $scope.associatedRequests.splice(i, 1);
          return true;
        }
      }

      return false;
    };

    /**
     * Create a new request
     * @param Object req the request data
     * @return boolean
     **/
    $scope.createRequest = function (req) {

      //clear any existing errors
      $rootScope.errors = [];
      $rootScope.messages = [];

      if ($requests.exceededMaxCharacters(req.description)) {
        // $rootScope.errors.push(
        //   'Description exceeds 3000 characters'
        // );
        $window.alert('Description exceeds 3000 characters');
        return false;
      }

      //add the associated requests
      for (var i = 0; i < $scope.associatedRequests.length; i++) {
        req.associatedRequests.push(
          $scope.associatedRequests[i].id
        );
      }

      //make sure this is a valid request format
      if (!$requests.valid(req)) {
        return false;
      }

      //try to create the new request
      return $api.create('requests', {
        data: req
      }).then(function (request) {
        //redirect them back to the request if it was created successfully
        if (request.success && request.response) {
          $location.path('/requests/' + request.response.id);
          $window.alert('Request created successfully.');
          return true;
        } else if (request && request.message) {
          // $rootScope.errors.push(request.message);
          $window.alert(request.message);
        } else {
          // $rootScope.errors.push('Create request API call failed.');
          $window.alert('Create request API call failed.');
        }

        return false;
      });
    };

    /**
     * Set the request they're trying to link to
     * @param object request
     * @return boolean
     **/
    $scope.setRequest = function (request) {
      $scope.selectedRequest = request;
      return true;
    };
  }
]);